#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>

using namespace std;

const int X = 100;
int rk[X], pr[X];
int table[X][X];
vector <pair <pair <int, int>, int> > ans;


void build_dsu()
{
    for(int i = 0; i < X; i++) pr[i] = i;
}

int get_dsu(int a)
{
    if(a == pr[a]) return a;
    return pr[a] = get_dsu(pr[a]);
}

int uniq_dsu(int a, int b)
{
    int a1 = get_dsu(a);
    int b1 = get_dsu(b);
    if(a1 != b1)
    {
        ans.push_back(make_pair(make_pair(a + 1, b + 1), table[a][b]));
        if(rk[a1] == rk[b1])
        {
            rk[a1]++;
        }
        if(rk[b1] < rk[a1])
        {
            pr[b1] = a1;
        }
        else
        {
            pr[a1] = b1;
        }
    }
}
bool cmp(pair <int, int> a, pair<int, int> b)
{
    return table[a.first][a.second] > table[b.first][b.second];
}

vector <pair <int, int> > edg;

int main() {
    ios_base::sync_with_stdio(false);
    int n;
    build_dsu();
    cin >> n;
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < n; j++)
        {
            cin >> table[i][j];
        }
    }
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < i; j++)
        {
            edg.push_back(make_pair(i, j));
        }
    }
    sort(edg.begin(), edg.end(), cmp);
    for(int i = 0; i < edg.size(); i++)
    {
        uniq_dsu(edg[i].first, edg[i].second);
    }
    cout << "YES\n";
    cout << ans.size() << '\n';
    for(int i = 0; i < ans.size(); i++)
    {
        cout << ans[i].first.first << ' ' << ans[i].first.second << ' ' << ans[i].second << '\n';
    }
    return 0;
}
